
// BIConsolidatedTax.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPConsolidatedTax.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIConsolidatedTax.h"
#endif
#import "BIAppVersioning.h"


@class BITax;

/*!
    @class       BIConsolidatedTax
    @abstract    BIConsolidatedTax is a class which acts as a collection of independent taxes.
    @discussion  BIConsolidatedTax is a collection of independent taxes and it manages how these taxes interact with one another, ie. the order they are calculated.  Each independent tax has an associated consolidated tax representation and when setting a tax on a slip, you are actually setting a consolidated tax and not a BITax.  You are always working with consolidated taxes in the application, and normally the only time you use a BITax is when you are creating/editing a BIConsolidatedTax.
*/


@interface BIConsolidatedTax : BL_SUPER_CLASSNAME_MUNGE(ConsolidatedTax) 
{
}

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (BITax*)primaryTax;
- (BITax*)secondaryTax;
- (NSArray*)taxes;

// the duplicate is persistent
- (BIConsolidatedTax*)persistentDuplicate;

- (void)removeTax:(BITax*)aTax;
- (void)removeTaxes:(NSArray*)taxes;
- (BITaxConsolidatedTaxEntry*)taxConsolidatedTaxEntryWithTax:(BITax*)aTax;

- (void)setTaxConsolidatedTaxEntry:(BITaxConsolidatedTaxEntry*)anEntry
                             index:(int)anIndex;

- (NSDictionary*)archiveWithDictionary;
- (void)unarchiveFromDictionary:(NSDictionary*)aDict usingTaxesMap:(NSDictionary*)aMap;

- (NSString*)taxesFormulaDescription;

- (void)calculateOrderIndexes;

- (NSString*)nameWithRates;
- (NSString*)smartName;

- (BOOL)containsTax:(BITax*)aTax;

- (NSString *)moneyWorksTaxCode;
- (void)setMoneyWorksTaxCode:(NSString *)aTaxCode;

@end
